############################################################################################
#####This is a simplified code to easily analysze UTA analytic cytometry####################
##### We hope you will enjoy looking at your data and do not hesitate  #####################
##### to contact us.                                                   #####################
##### This code is written for Biologist with a minimum or zero coding #####################
##### expirience so, it is designed for wet lab scientist              #####################
############################################################################################

##############################################
####################Call functions    ########
##############################################

# Set your working directory.
setwd("/Users/nlemus/Desktop/NicolasFACS2018/")    
#  Call the functions for Analytic flow cytometry of miRNAs dual reporter assays.
source("Analysis_functions_4.0.R")    

##################################################################
##### Load your own FCS files 2.0#################################
##################################################################
#Select the folder where your FCS files are.
setwd("March2018/26.03.2018_pUTA_miRNA/HTC116/" )
#Character Vector with FCS files names, in this case just P3
fileNames <-Sys.glob("*P3.fcs")                   

##################################################################
##### Create your working List  #################################
##################################################################

### You will apply the bin.data function to each file on your working directory, it means that each object inside the list ##### 
### correspond to an FCS file or experimental unit. Each FCS processed object will have:                                   ##### 
### 1. Raw data (CFP,YFP,ratio,fold) without logarithmic transformation
### 2. Bin data  (All logaritmically transform)
###      2.1 Bin CFP and YFP it will be used for transfer function generation
###      2.1 Ratio of CFP / YFP per each CFP bin
###      2.2 Fold Repression per each bin. It just another way to see repression so 1 means that 100% is being repress.
###3. Descriptive statistics with quartiles median, max, and min.
Functions<-lapply(fileNames, function(x) bin.data.FscH(x,bin.size = 0.05)) 
#Check the names of your files and asign it to your list. 
head(fileNames)
table_names<-data.frame(fileNames)
names(Functions)<-fileNames
####### You might also use another software to plot your data, using the following function##
####### You will create a CSV file of all your list,the fist column has the log values of  ##
####### each YFP bin, and the other columns cointain the CFP values of each element in your##
####### list, with the name of your FCS files.                                             ##

Export(Functions,fileNames,"Output.csv")

####
#################################
# now you are ready to plot     #
#          your data           #
#################################
##########Simplest plotting##########
#pdf("YourName.pdf",3.18,6.75) 
##This will generate a PDF per plot 
##To activate erase the hashtag at the begining of this line and at the end in dev.off() line
plot.miR(Functions,fil_num = c(33,35,34,36),control = 32,ylim = c(1,8),l_y = 8,
         Leg = c("Empty","miR-92a","U3-1 copy","U3-3 copies","miR-21"),main= "983" ,col.m=c("black","blue","red","green3","purple"),
         cex = 0.7,mu.cex = 0.3)
#dev.off()

#Function explanation 

#plot.miR<-function(data,                               #Your list of FCS files 
#                   fil_num = c(1),                     #Vector with the indexes for your samples inside the List maximum 5
#                   control = 1 ,                       #Numerical value that correspond to your control, in other words the index inside the list of
#                                                       #   of your negative control (i.e empty or non-cognate sample)
#                   Leg=c("control","1","1","1","1"),   #Legend= Character vector with the id of your experimental unists. (i.e miR 21 or U78) 
#                                                       #   max 5 elements, the first usually the control
#                   cex=1,                              #size the legend 
#                   l_x=1,                              #x positions of your legend 
#                   l_y=8,                              #y positions of your legend 
#                   le.pch=20,                          #Dot type on the legend 
#                   main= c("titulo"),                  #Tittle of your plot
#                   po.pch=19,                          #Type of dots of the transfer functions
#                   mu.cex=0.5,                         #Dots sites of the transfer functions
#                   xlim=c(1,10),                       #X axis range
#                   ylim=c(1,8),                        #Y axis ranges
#                   col.m=c("black","blue"))            #Color of your transfer functions max 5.The first has to be the control usually black















